import { View, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../../SkeletonElement";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { MyRefundStyle } from "../../../../../screens/Profile/MyRefund/MyRefundStyle";

import { refundStyle } from "../../../../../screens/Profile/MyRefund/RefundRequest/RefundRequestStyle";
import { refundDetailsStyle } from "../../../../../screens/Profile/MyRefund/RefundList/RefundDetails/refundDetailsStyle";
const RenderItem = ({ item }) => {
    return (
        <View style={refundStyle.container}>
            <View style={refundDetailsStyle.detailHeader}>
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 240)}/>
                    <View style={styles.marginTop(10)}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 240)} />
                    </View>
                </View>
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 240)} />
                    <View style={styles.marginTop(10)}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(40, 240)}/>
                    </View>
                </View>
            </View>
            <View
                style={[
                    MyRefundStyle.lastRefund,
                    styles.marginTop(24),
                ]}
            >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 280)}/>
                    <View style={styles.marginTop(14)}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 240)} />
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 190)} />
                    </View>
                </View>
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(85, 300)} />
                </View>
                <View style={styles.skeletonElementContainer1}>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle5} />
                </View>
            </View>
            <View
                style={[
                    MyRefundStyle.lastRefund,
                    styles.marginTop(18),
                ]}
            >
                <SkeletonElement  wrapperStyle={styles.skeletonWrapper(14, 80)} />
            </View>
            <View style={styles.marginTop(18)} >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(16, 160)}/>
                </View>
                <View style={styles.skeletonElementContainer2}>
                    <View style={styles.containerCommonStyle}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(80, 300)} />
                    </View>
                    <View style={styles.containerCommonStyle}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(80, 300)} />
                    </View>
                    <View style={styles.containerCommonStyle}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(80, 300)} />
                    </View>
                </View>
            </View>
            <View style={styles.marginTop(18)} >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(16, 160)} />
                </View>
                <View>
                    <View style={styles.containerCommonStyle}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(100, 40)} />
                    </View>
                    <View style={styles.marginTop(20)}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(50, 40)} />
                    </View>
                </View>
            </View>
        </View>
    );
};
const RefundDetailsSkeleton = () => {
    return (
        <View>
            <FlatList
                data={[1]}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key-${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default RefundDetailsSkeleton;

const styles = StyleSheet.create({
    marginTop: (value) => ({
        marginTop: dpr(value),
    }),

    skeletonWrapper: (height, minusWidth) => ({
        height: dpr(height),
        width: dpr("wf") - dpr(minusWidth),
    }),

    containerCommonStyle: {
        marginEnd: dpr(15)
    },

    skeletonElementContainer1: {
        marginVertical: dpr(10),
    },

    skeletonElementContainer2: {
        flexDirection: "row"
    },

    skeletonWrapperStyle5: {
        height: dpr(12),
    },
});
